
/********************************************************************************/
/*                        	* AD9834 - Waveform Generator code *                */
/*                            By George A. Adamidis                             */
/*                            Ver 1.0 - Ver 1.0 - Jan 26, 2013                  */ 
/********************************************************************************/
// All rights are reserved 


// MPLAB V8.0
// Mcc18 V2.1
// Loaded on a PIC18F4620 microcontroler
// All timing routines have been written for 16MHz master clock.
//--------------------------------------------------------------------------------

#include <delays.h>         	/* for 'Delay purpose routines'     */
#include <p18f1220.h>        	/* for pic18f242                    */
//#include <p18cxxx.h>        	/* for TRISB and PORTB declarations */
#include "definitions.h"        /* pin and other definitions        */

/* Set configuration bits */ 
#pragma config OSC = XT   		// set XT (4MHz crystal)
#pragma config WDT = ON  		
#pragma config WDTPS = 16384 
#pragma config LVP = OFF  		
#pragma config BOR = ON
#pragma config BORV = 42
#pragma config MCLRE = ON


/*Code protection*/
#pragma config CP0 = ON
#pragma config CP1 = ON  


// Functions:

extern void Send_frame(unsigned char* pframex, unsigned char chip); // Transmits the 16-bit *pframex to the AD9834, through the serial interface (FDATA, FSYNC, SCLK) (Keyboard.c)
void Pilot_On(void);   			//Set U3 frequency to 19KHz 	
void Carrier_On(void); 			//Set U4 frequency to 38KHz 
void initialize (void);			// Initialization routine
void CLRWDT (void);			 	// Clear WDT
unsigned char key (void); 		// returns 0, 1, 2 or 3 if no key, key19KHZ, key38KHZ or both keys are on, respectively
		
//constants:
unsigned char Sinus_A[]=   {0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0}; 	// AD9834's 16bit command (control register). Sinus signal -Freq0-Phase0 
unsigned char reset_AD[]=  {0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0};	// AD9834's 16bit command (control register). Reset- analog output at midscale

//Global variables:
unsigned char flag;			// keypressed flag
	

/****************** Main body starts here *************************/
void main ()
{
	
	Delay10KTCYx(40);                   // wait 0.4s for peripherals to be initialized
	CLRWDT();
    initialize();
	flag=1;
	
	while(1)
		{
			CLRWDT();
	
			switch (key())
				{
					case 0:
					
						LED1=1;
						LED2=1;	
						if (flag>0)
							{
								initialize();
								flag=0;
							}
					break;

					case 1:
					    Send_frame(&reset_AD[15], 0);				// Reset U3	
						LED1=0;
						LED2=1;
						if (flag>1)	Send_frame(&Sinus_A[15], 1);	// Restart U4
						flag=1;
					break;

					case 2:
						Send_frame(&reset_AD[15], 1);		// Reset U4		
						LED1=1;
						LED2=0;
						if (flag>0)	Send_frame(&Sinus_A[15], 0);	// Restart U3
						flag=2;
					break;					

					case 3:
						Send_frame(&reset_AD[15], 0);		// Reset U3	
						Send_frame(&reset_AD[15], 1);		// Reset U4	
						LED1=0;
						LED2=0;
						flag=3;	
					break;

				}


	    }


//infinitive loop ends here
}

/****************** Main body Ends here ****************************/


//-------------------------------------------------------------------
// Initialization routine
void initialize (void)			 
{
	
	TRISB=0;                            // configure portB for output
	TRISA=0b00000011;                   // configure portA - RA0, RA1 for input
    ADCON1=0b11111111;					// PORTA as digital IO
	
      
	Send_frame(&reset_AD[15], 0);		// Reset U3	
	Send_frame(&reset_AD[15], 1);		// Reset U4	
	Delay1KTCYx(2);  					
	
	Pilot_On();					// Turn on 19KHz pilot signal
	Carrier_On();				// Turn on 38KHz carrier   
	Delay1KTCYx(1);  					
	
	Send_frame(&Sinus_A[15], 0);		// U3 starts with Sinus output
	Send_frame(&Sinus_A[15], 1);		// U4 starts with Sinus output
	
	//Turn on LEDs
	LED1=1;
	LED2=1;

   }


//-------------------------------------------------------------------


// Turn on 19KHz pilot signal - Set U3 frequency to 19KHz 
void Pilot_On(void)				
{
	unsigned char frame[16];							// Contains a 16-bit frame - LSB 																
	unsigned char frame2[16];							// Contains a 16-bit frame - MSB
	
	// 19KHz NCO value (clock 10MHz)= 510027 - 0b11111 00100001001011
	// 19KHz NCO value (clock 25MHz)= 204011 - 0b01100 01110011101011 
  	

	// For 10MHz clock
	frame[13]=0;
	frame[12]=0;
	frame[11]=1;
	frame[10]=0;
	frame[9]= 0;
	frame[8]= 0;
	frame[7]= 0;
	frame[6]= 1;
	frame[5]= 0;
	frame[4]= 0;
	frame[3]= 1;
	frame[2]= 0;
	frame[1]= 1;
	frame[0]= 1;
	
	
	frame2[13]=0;
	frame2[12]=0;
	frame2[11]=0;
	frame2[10]=0;
	frame2[9]= 0;
	frame2[8]= 0;
	frame2[7]= 0;
	frame2[6]= 0;
	frame2[5]= 0;
	frame2[4]= 1;
	frame2[3]= 1;
	frame2[2]= 1;
	frame2[1]= 1;
	frame2[0]= 1;

   
//  /* For 25MHz Clock */
//	frame[13]=0;
//	frame[12]=1;
//	frame[11]=1;
//	frame[10]=1;
//	frame[9]= 0;
//	frame[8]= 0;
//	frame[7]= 1;
//	frame[6]= 1;
//	frame[5]= 1;
//	frame[4]= 0;
//	frame[3]= 1;
//	frame[2]= 0;
//	frame[1]= 1;
//	frame[0]= 1;
//	
//	
//	frame2[13]=0;
//	frame2[12]=0;
//	frame2[11]=0;
//	frame2[10]=0;
//	frame2[9]= 0;
//	frame2[8]= 0;
//	frame2[7]= 0;
//	frame2[6]= 0;
//	frame2[5]= 0;
//	frame2[4]= 0;
//	frame2[3]= 1;
//	frame2[2]= 1;
//	frame2[1]= 0;
//	frame2[0]= 0;



	// Set Freq0 register bits
	frame2[15]=0;					//D15 bit (AD9834)
	frame2[14]=1;					//D14 bit (AD9834)
	frame[15]=0;					//D15 bit (AD9834)
	frame[14]=1;					//D14 bit (AD9834)

	
	Send_frame(&frame[15],0);		// Send LSB-FREQ frame to AD9833
	Send_frame(&frame2[15],0);		// Send MSB-FREQ frame to AD9833



	// Phase shift - calibration start
	
	// Set Phase0 register bits
	frame[15]=1;					//D15 bit (AD9834)
	frame[14]=1;					//D14 bit (AD9834)
	frame[13]=0;					//D13 bit (AD9834)

   //Phase shift value - 60.625 degrees = 001010100000
  				 
	
	frame[11]=0;  //0
	frame[10]=0;  //0
	frame[9]= 1;  //1
	frame[8]= 0;  //0
	frame[7]= 1;  //1
	frame[6]= 0;  //0
	frame[5]= 1;  //1		
	frame[4]= 0;  //0		
	frame[3]= 0;  //0
	frame[2]= 0;  //0
	frame[1]= 0;  //0
	frame[0]= 0;  //0
	

    Send_frame(&frame[15],0);		// Send PHASE0 frame to AD9833

// } Phase shift - calibration End


	return;	
}


// Turn on 38KHz carrier signal - Set U4 frequency to 38KHz 
void Carrier_On(void)				
{

	unsigned char frame[16];							// Contains a 16-bit frame 																
	unsigned char frame2[16];							// Contains a 16-bit frame 
	
    //38KHz NCO value (clock 10MHz) = 1020054 - 0b111110 01000010010110
	//38KHz NCO value (clock 25MHz) = 0408022 - 0b011000 11100111010110

//	frame[13]=0;
//	frame[12]=1;
//	frame[11]=0;
//	frame[10]=0;
//	frame[9]= 0;
//	frame[8]= 0;
//	frame[7]= 1;
//	frame[6]= 0;
//	frame[5]= 0;
//	frame[4]= 1;
//	frame[3]= 0;
//	frame[2]= 1;
//	frame[1]= 1;
//	frame[0]= 0;
//	
//	frame2[13]=0;
//	frame2[12]=0;
//	frame2[11]=0;
//	frame2[10]=0;
//	frame2[9]= 0;
//	frame2[8]= 0;
//	frame2[7]= 0;
//	frame2[6]= 0;
//	frame2[5]= 1;
//	frame2[4]= 1;
//	frame2[3]= 1;
//	frame2[2]= 1;
//	frame2[1]= 1;
//	frame2[0]= 0;

    
    /*  25MHz */
    frame[13]=1;
	frame[12]=1;
	frame[11]=1;
	frame[10]=0;
	frame[9]= 0;
	frame[8]= 1;
	frame[7]= 1;
	frame[6]= 1;
	frame[5]= 0;
	frame[4]= 1; 
	frame[3]= 0;
	frame[2]= 1;
	frame[1]= 1;
	frame[0]= 0;
	
	frame2[13]=0;
	frame2[12]=0;
	frame2[11]=0;
	frame2[10]=0;
	frame2[9]= 0;
	frame2[8]= 0;
	frame2[7]= 0;
	frame2[6]= 0;
	frame2[5]= 0;
	frame2[4]= 1;
	frame2[3]= 1;
	frame2[2]= 0;
	frame2[1]= 0;
	frame2[0]= 0;



	// Set Freq0 register bits
	frame2[15]=0;					//D15 bit (AD9834)
	frame2[14]=1;					//D14 bit (AD9834)
	frame[15]=0;					//D15 bit (AD9834)
	frame[14]=1;					//D14 bit (AD9834)

	Send_frame(&frame[15],1);			// Send LSB-FREQ frame to AD9833
	Send_frame(&frame2[15],1);		// Send MSB-FREQ frame to AD9833

	return;	
}



/******************************************************/
void CLRWDT (void)			 	// Clear WDT
{
	_asm 
	CLRWDT
	_endasm

}



/*******************************************************/
unsigned char key (void) 		// returns 0, 1, 2 or 3 if no key, key19KHZ, key38KHZ or both keys are on, respectively
{
unsigned char buf;
buf=0;

if (Key19KHZ) buf=buf+1;
if (Key38KHZ) buf=buf+2;

return buf;

}